#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)4e18;

struct Mast {
    ll x, h;
    int id;
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Mast> a(n);
    for(int i = 0; i < n; i++) cin >> a[i].x;
    for(int i = 0; i < n; i++){
        cin >> a[i].h;
        a[i].id = i;
    }

    sort(a.begin(), a.end(), [](auto &p, auto &q){
        return p.x < q.x;
    });

    vector<ll> ans(n, INF);

    /* --- check neighboring masts directly --- */
    for(int i = 0; i + 1 < n; i++){
        if(a[i+1].h >= a[i].h){
            ans[a[i].id] = min(ans[a[i].id],
                llabs(a[i+1].x - a[i].x) + llabs(a[i+1].h - a[i].h));
        }
        if(a[i].h >= a[i+1].h){
            ans[a[i+1].id] = min(ans[a[i+1].id],
                llabs(a[i+1].x - a[i].x) + llabs(a[i+1].h - a[i].h));
        }
    }

    /* --- check ropes --- */
    for(int i = 0; i + 1 < n; i++){
        ll x1 = a[i].x, h1 = a[i].h;
        ll x2 = a[i+1].x, h2 = a[i+1].h;

        ll x0_num = (h1 + x1 + h2 - x2);
        // x0 = x0_num / 2

        for(int t = i; t <= i + 1; t++){
            ll xi = a[t].x, hi = a[t].h;

            // projection on left branch
            ll xl = min(xi, x0_num / 2);
            ll yl = h1 - (xl - x1);
            if(yl >= hi){
                ll dx = xi - xl;
                ll dy = yl - hi;
                ans[a[t].id] = min(ans[a[t].id],
                    (ll)ceil(sqrt((long double)dx*dx + (long double)dy*dy)));
            }

            // projection on right branch
            ll xr = max(xi, x0_num / 2);
            ll yr = h2 + (xr - x2);
            if(yr >= hi){
                ll dx = xr - xi;
                ll dy = yr - hi;
                ans[a[t].id] = min(ans[a[t].id],
                    (ll)ceil(sqrt((long double)dx*dx + (long double)dy*dy)));
            }
        }
    }

    for(int i = 0; i < n; i++){
        if(ans[i] == INF) cout << -1 << '\n';
        else cout << ans[i] << '\n';
    }
}